<?php
require __DIR__ . '/includes/config.php';
require __DIR__ . '/includes/functions.php';

$artists = read_json('artists.json');
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Londons Energy • Artist Portal</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <link rel="stylesheet" href="assets/css/main.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
  <script src="assets/js/main.js" defer></script>
</head>
<body class="dark-bg">
  <div class="page-bg"></div>

  <!-- TOP NAV -->
  <header class="site-header site-header--sticky">
    <div class="site-header-inner">
      <a href="index.php" class="site-brand">
        <img
          src="https://londonsenergyradio.co.uk/wp-content/uploads/2022/12/Energy-radio-p3h439ea3kdydq5pmbj4z4m1ek89863lffdvjk6qmc.png"
          alt="Londons Energy Radio"
          class="site-logo"
        >
        <div class="site-brand-text">
          <span class="site-brand-top">Londons Energy Radio</span>
          <span class="site-brand-sub">Artist Portal</span>
        </div>
      </a>

      <button class="nav-toggle" type="button" aria-controls="primary-nav" aria-expanded="false">

        <span class="sr-only">Menu</span>

        <i class="fa-solid fa-bars"></i>

      </button>


      <nav class="site-nav" id="primary-nav" aria-label="Primary">
        <a href="index.php" class="nav-link nav-link--active">Artists</a>
        <a href="packages.php" class="nav-link">Packages</a>
        <a href="submit-artist.php" class="nav-link">Submit Music</a>
        <a href="login.php" class="nav-link nav-link--outline">
          <i class="fa-solid fa-user"></i>
          Login
        </a>
      </nav>
    </div>
  </header>

  <div class="nav-overlay" data-nav-close></div>

  <main>
    <!-- HERO -->
    <section class="hero-landing">
      <div class="hero-landing-inner">
        <div class="hero-landing-text">
          <p class="hero-kicker">Keeping It Energy</p>
          <h1>Get Your Music On<br><span>Londons Energy Radio</span></h1>
          <p class="hero-copy">
            A dedicated hub for artists and labels who want real airplay, a permanent profile,
            and the chance to be featured across our radio, app and socials.
          </p>
          <div class="hero-actions">
            <a href="submit-artist.php" class="btn-primary">
              <i class="fa-solid fa-bolt"></i>
              Submit Your Music
            </a>
            <a href="packages.php" class="btn-secondary">
              View Packages
            </a>
          </div>
          <div class="hero-meta">
            <span><i class="fa-solid fa-wave-square"></i> 14 & 30 day campaigns</span>
            <span><i class="fa-solid fa-star"></i> Free forever artist profiles</span>
          </div>
        </div>

        <div class="hero-landing-card">
          <div class="hero-card-header">
            <span class="hero-card-pill">
              <span class="live-dot"></span> On Air
            </span>
            <span class="hero-card-label">Artist Spotlight</span>
          </div>
          <div class="hero-card-body">
            <div class="hero-card-image">
              <div class="hero-card-gradient"></div>
            </div>
            <div class="hero-card-text">
              <p class="hero-card-title">Your track. Our airwaves.</p>
              <p class="hero-card-sub">
                Submit, get reviewed, and once approved your profile goes live with links,
                artwork and featured tracks.
              </p>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- ABOUT STRIP -->
    <section class="about-strip">
      <div class="shell">
        <div class="about-grid">
          <div class="about-item">
            <h3>We Are Committed</h3>
            <p>
              Londons Energy Radio is serious about breaking new talent. We work to give your music the
              recognition it deserves with curated airplay and professional presentation.
            </p>
          </div>
          <div class="about-item">
            <h3>Airplay + Profile</h3>
            <p>
              Every approved artist gets a dedicated glowing profile page, plus airplay depending on the
              promo package you choose.
            </p>
          </div>
          <div class="about-item">
            <h3>Built-In Upsell</h3>
            <p>
              Upgrade with social media shoutouts, app features, or even a full artist website – all
              managed via your portal.
            </p>
          </div>
        </div>
      </div>
    </section>

    <!-- FEATURED ARTISTS -->
    <section class="shell artists-section">
      <div class="artists-header">
        <div>
          <h2 class="section-heading">Featured Artists</h2>
          <p class="section-subtitle">
            Artists that have submitted to Londons Energy Radio and been approved for airplay.
            Click a card to open a full profile with tracks and visuals.
          </p>
        </div>
        <a href="submit-artist.php" class="btn-tertiary">
          Become a Featured Artist
        </a>
      </div>

      <?php
      $hasApproved = false;
      foreach ($artists as $artist) {
          $status = $artist['status'] ?? 'approved';
          if ($status === 'approved') { $hasApproved = true; break; }
      }
      ?>

      <?php if (!$hasApproved): ?>
        <div class="empty-state">
          <p>No artists are live yet. Be the first to submit your music.</p>
          <a href="submit-artist.php" class="btn-primary">Submit Your Music</a>
        </div>
      <?php else: ?>
        <div class="artist-grid">
          <?php foreach ($artists as $artist): ?>
            <?php
              $status = $artist['status'] ?? 'approved';
              if ($status !== 'approved') continue;

              $featuredTitle = '';
              if (!empty($artist['tracks']) && is_array($artist['tracks'])) {
                  foreach ($artist['tracks'] as $t) {
                      if (!empty($t['is_featured'])) {
                          $featuredTitle = $t['title'] ?? '';
                          break;
                      }
                  }
                  if ($featuredTitle === '' && !empty($artist['tracks'][0]['title'])) {
                      $featuredTitle = $artist['tracks'][0]['title'];
                  }
              } elseif (!empty($artist['featured_track']['title'])) {
                  $featuredTitle = $artist['featured_track']['title'];
              }
            ?>
            <a href="artist.php?artist=<?= urlencode($artist['slug']) ?>" class="artist-card">
              <div class="artist-thumb">
                <img
                  src="<?= htmlspecialchars($artist['profile_image']) ?>"
                  alt="<?= htmlspecialchars($artist['name']) ?>"
                >
                <?php if (!empty($artist['featured_on_app'])): ?>
                  <div class="badge-featured-app">
                    <i class="fa-solid fa-mobile-screen-button"></i>
                    Featured on our App
                  </div>
                <?php endif; ?>
              </div>
              <div class="artist-card-body">
                <h3><?= htmlspecialchars($artist['name']) ?></h3>
                <p class="artist-tagline">
                  <?= htmlspecialchars($artist['tagline'] ?? 'Artist on Londons Energy Radio') ?>
                </p>
                <?php if ($featuredTitle): ?>
                  <p class="artist-track">
                    <i class="fa-solid fa-music"></i>
                    <?= htmlspecialchars($featuredTitle) ?>
                  </p>
                <?php endif; ?>
              </div>
            </a>
          <?php endforeach; ?>
        </div>
      <?php endif; ?>
    </section>
  </main>

  <footer class="site-footer">
    KEEPING IT ENERGY • LONDONS ENERGY RADIO
  </footer>
</body>
</html>
