<?php
require __DIR__ . '/includes/config.php';
require __DIR__ . '/includes/functions.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Londons Energy • Artist Packages</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <link rel="stylesheet" href="assets/css/main.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
  <script src="assets/js/main.js" defer></script>
</head>
<body class="dark-bg">
  <div class="page-bg"></div>

  <!-- TOP NAV -->
  <header class="site-header site-header--sticky">
    <div class="site-header-inner">
      <a href="index.php" class="site-brand">
        <img
          src="https://londonsenergyradio.co.uk/wp-content/uploads/2022/12/Energy-radio-p3h439ea3kdydq5pmbj4z4m1ek89863lffdvjk6qmc.png"
          alt="Londons Energy Radio"
          class="site-logo"
        >
        <div class="site-brand-text">
          <span class="site-brand-top">Londons Energy Radio</span>
          <span class="site-brand-sub">Artist Portal</span>
        </div>
      </a>

      <button class="nav-toggle" type="button" aria-controls="primary-nav" aria-expanded="false">

        <span class="sr-only">Menu</span>

        <i class="fa-solid fa-bars"></i>

      </button>


      <nav class="site-nav" id="primary-nav" aria-label="Primary">
        <a href="index.php" class="nav-link">Artists</a>
        <a href="packages.php" class="nav-link nav-link--active">Packages</a>
        <a href="submit-artist.php" class="nav-link">Submit Music</a>
        <a href="login.php" class="nav-link nav-link--outline">
          <i class="fa-solid fa-user"></i>
          Login
        </a>
      </nav>
    </div>
  </header>

  <div class="nav-overlay" data-nav-close></div>

  <main>
    <!-- PACKAGES HERO -->
    <section class="packages-hero">
      <div class="shell">
        <div class="packages-hero-inner">
          <div>
            <p class="hero-kicker">Artist Submission</p>
            <h1>Choose How Hard You Push</h1>
            <p class="hero-copy">
              Whether you’re testing the waters or going all in, we’ve got options. Every package
              gives you a permanent artist profile on the Londons Energy portal – your digital home
              on our platform.
            </p>
          </div>
          <div class="packages-hero-tag">
            <span><i class="fa-solid fa-headphones"></i> On-air promo</span>
            <span><i class="fa-solid fa-bullhorn"></i> Social pushes</span>
            <span><i class="fa-solid fa-laptop-code"></i> Optional website builds</span>
          </div>
        </div>
      </div>
    </section>

    <!-- PACKAGES GRID -->
    <section class="shell packages-section">
      <div class="packages-grid">
        <!-- 14 days -->
        <article class="package-card">
          <h3>14 Days</h3>
          <p class="package-subtitle">Dip your toes into radio promotion.</p>
          <div class="package-price">
            <span class="currency">£</span>10.00<span class="per">/once</span>
          </div>
          <ul class="package-list">
            <li class="included"><i class="fa-solid fa-check"></i> Artist Profile</li>
            <li class="included"><i class="fa-solid fa-check"></i> Featured Artist Slot</li>
            <li class="included"><i class="fa-solid fa-check"></i> 14 Days Airplay</li>
            <li class="included"><i class="fa-solid fa-check"></i> Free Forever Profile</li>
            <li class="excluded"><i class="fa-solid fa-xmark"></i> Cloud Promotion</li>
            <li class="excluded"><i class="fa-solid fa-xmark"></i> Social Media Shouts</li>
          </ul>
          <a href="submit-artist.php" class="btn-outline block-btn">Start 14-Day Promo</a>
        </article>

        <!-- 30 days -->
        <article class="package-card package-featured">
          <div class="package-badge">Most Popular</div>
          <h3>30 Days</h3>
          <p class="package-subtitle">Serious push with multi-channel promo.</p>
          <div class="package-price">
            <span class="currency">£</span>20.00
          </div>
          <ul class="package-list">
            <li class="included"><i class="fa-solid fa-check"></i> Artist Profile</li>
            <li class="included"><i class="fa-solid fa-check"></i> Featured Artist Spot</li>
            <li class="included"><i class="fa-solid fa-check"></i> 30 Days Airplay</li>
            <li class="included"><i class="fa-solid fa-check"></i> Free Forever Profile</li>
            <li class="included"><i class="fa-solid fa-check"></i> Cloud Promotion</li>
            <li class="included"><i class="fa-solid fa-check"></i> Social Media Shouts</li>
          </ul>
          <a href="submit-artist.php" class="btn-primary block-btn">Start 30-Day Promo</a>
        </article>

        <!-- Label offer -->
        <article class="package-card">
          <h3>Label Offer</h3>
          <p class="package-subtitle">For labels managing a roster of talent.</p>
          <div class="package-price">
            <span class="currency">£</span>50.00<span class="per">/month</span>
          </div>
          <ul class="package-list">
            <li class="included"><i class="fa-solid fa-check"></i> Record Label Page</li>
            <li class="included"><i class="fa-solid fa-check"></i> Up to 50 Submissions</li>
            <li class="included"><i class="fa-solid fa-check"></i> Featured Artists</li>
            <li class="included"><i class="fa-solid fa-check"></i> 30 Days On Air</li>
            <li class="included"><i class="fa-solid fa-check"></i> Label & Artist Pages</li>
            <li class="included"><i class="fa-solid fa-check"></i> Logo in Sponsors</li>
          </ul>
          <a href="submit-artist.php" class="btn-outline block-btn">Talk To Us</a>
        </article>
      </div>

      <div class="addons">
        <h3>Add-Ons</h3>
        <ul>
          <li>+ <strong>£10</strong> Social Media Shoutouts</li>
          <li>+ <strong>£20</strong> App Appearances / Featured</li>
          <li>+ <strong>£100</strong> Custom Artist Website Build</li>
        </ul>
      </div>
    </section>
  </main>

  <footer class="site-footer">
    KEEPING IT ENERGY • LONDONS ENERGY RADIO
  </footer>
</body>
</html>
