<?php
require __DIR__ . '/includes/config.php';
require __DIR__ . '/includes/functions.php';

$errors  = [];
$success = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name     = trim($_POST['name'] ?? '');
    $email    = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $confirm  = $_POST['password_confirm'] ?? '';

    if ($name === '') {
        $errors[] = "Your name is required.";
    }
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errors[] = "A valid email address is required.";
    }
    if (strlen($password) < 6) {
        $errors[] = "Password must be at least 6 characters.";
    }
    if ($password !== $confirm) {
        $errors[] = "Passwords do not match.";
    }

    if (!$errors) {
        $users = read_json('users.json');
        foreach ($users as $u) {
            if (strtolower($u['email']) === strtolower($email)) {
                $errors[] = "This email is already registered. Please login instead.";
                break;
            }
        }

        if (!$errors) {
            $newUserId = $users ? (max(array_column($users, 'id')) + 1) : 1;

            $users[] = [
                "id"            => $newUserId,
                "role"          => "artist",
                "name"          => $name,
                "email"         => $email,
                "password_hash" => password_hash($password, PASSWORD_DEFAULT),
                "status"        => "pending"
            ];
            write_json('users.json', $users);
            $success = true;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Register • Londons Energy Artist Portal</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <link rel="stylesheet" href="assets/css/main.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
  <script src="assets/js/main.js" defer></script>
</head>
<body class="dark-bg">
  <div class="page-bg"></div>

  <header class="site-header site-header--sticky">
    <div class="site-header-inner">
      <a href="index.php" class="site-brand">
        <img
          src="https://londonsenergyradio.co.uk/wp-content/uploads/2022/12/Energy-radio-p3h439ea3kdydq5pmbj4z4m1ek89863lffdvjk6qmc.png"
          alt="Londons Energy Radio"
          class="site-logo"
        >
        <div class="site-brand-text">
          <span class="site-brand-top">Londons Energy Radio</span>
          <span class="site-brand-sub">Artist Portal</span>
        </div>
      </a>

      <button class="nav-toggle" type="button" aria-controls="primary-nav" aria-expanded="false">

        <span class="sr-only">Menu</span>

        <i class="fa-solid fa-bars"></i>

      </button>


      <nav class="site-nav" id="primary-nav" aria-label="Primary">
        <a href="index.php" class="nav-link">Artists</a>
        <a href="packages.php" class="nav-link">Packages</a>
        <a href="submit-artist.php" class="nav-link">Submit Music</a>
        <a href="login.php" class="nav-link">
          <i class="fa-solid fa-right-to-bracket"></i>
          Login
        </a>
      </nav>
    </div>
  </header>

  <div class="nav-overlay" data-nav-close></div>

  <main class="auth-wrapper">
    <div class="auth-card">
      <div class="auth-logo">
        <img
          src="https://londonsenergyradio.co.uk/wp-content/uploads/2022/12/Energy-radio-p3h439ea3kdydq5pmbj4z4m1ek89863lffdvjk6qmc.png"
          alt="Londons Energy Radio"
        >
      </div>
      <h1 class="auth-title">Create Your Account</h1>
      <p class="auth-subtitle">
        Register for the Londons Energy artist portal. You can then submit your profile and tracks for approval.
      </p>

      <?php if ($success): ?>
        <div class="auth-success">
          <p><strong>Account created!</strong></p>
          <p>Your account is now pending approval. You can login once an admin has activated it.</p>
          <div style="margin-top:1rem;display:flex;gap:0.6rem;flex-wrap:wrap;justify-content:center;">
            <a href="login.php" class="btn-primary auth-btn-main">
              <i class="fa-solid fa-right-to-bracket"></i>
              Go to Login
            </a>
            <a href="submit-artist.php" class="btn-secondary auth-btn-secondary">
              Submit Artist Profile
            </a>
          </div>
        </div>
      <?php else: ?>

        <?php if ($errors): ?>
          <div class="auth-errors">
            <ul>
              <?php foreach ($errors as $e): ?>
                <li><?= htmlspecialchars($e) ?></li>
              <?php endforeach; ?>
            </ul>
          </div>
        <?php endif; ?>

        <form method="post" class="auth-form">
          <div class="auth-field">
            <label for="name">Full Name / Artist Name</label>
            <div class="auth-input-wrap">
              <i class="fa-solid fa-user"></i>
              <input
                type="text"
                id="name"
                name="name"
                required
                value="<?= htmlspecialchars($_POST['name'] ?? '') ?>"
              >
            </div>
          </div>

          <div class="auth-field">
            <label for="reg_email">Email</label>
            <div class="auth-input-wrap">
              <i class="fa-solid fa-at"></i>
              <input
                type="email"
                id="reg_email"
                name="email"
                required
                value="<?= htmlspecialchars($_POST['email'] ?? '') ?>"
              >
            </div>
          </div>

          <div class="auth-field">
            <label for="reg_password">Password</label>
            <div class="auth-input-wrap">
              <i class="fa-solid fa-lock"></i>
              <input
                type="password"
                id="reg_password"
                name="password"
                required
              >
            </div>
          </div>

          <div class="auth-field">
            <label for="reg_password_confirm">Confirm Password</label>
            <div class="auth-input-wrap">
              <i class="fa-solid fa-lock"></i>
              <input
                type="password"
                id="reg_password_confirm"
                name="password_confirm"
                required
              >
            </div>
          </div>

          <div class="auth-actions">
            <button type="submit" class="btn-primary auth-btn-main">
              <i class="fa-solid fa-user-plus"></i>
              Create Account
            </button>
          </div>
        </form>

        <div class="auth-footer-links">
          <a href="index.php" class="btn-secondary auth-btn-secondary">
            ← Back to Portal
          </a>
          <p>Already have an account? <a href="login.php">Login here</a>.</p>
        </div>

      <?php endif; ?>
    </div>
  </main>

  <footer class="site-footer">
    KEEPING IT ENERGY • LONDONS ENERGY RADIO
  </footer>
</body>
</html>
